/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.items;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import noppes.npcs.CustomRegisters;
import noppes.npcs.api.ICustomElement;
import noppes.npcs.api.INbt;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.client.renderer.ModelBuffer;
import noppes.npcs.constants.EnumParts;
import noppes.npcs.reflection.item.ItemArmorReflection;
import noppes.npcs.util.Util;
import org.lwjgl.util.vector.Vector3f;

public class CustomArmor
extends ItemArmor
implements ICustomElement {
    protected NBTTagCompound nbtData;
    protected ItemStack repairItemStack;
    protected int enchantability = 0;
    public ResourceLocation objModel = null;
    private final Map<EnumParts, List<String>> parts = new HashMap<EnumParts, List<String>>();
    private final Map<ItemCameraTransforms.TransformType, Optional<TRSRTransformation>> cameraData = new HashMap<ItemCameraTransforms.TransformType, Optional<TRSRTransformation>>();

    public static ItemArmor.ArmorMaterial getMaterialArmor(NBTTagCompound nbtItem) {
        String materialName;
        switch (materialName = nbtItem.func_150297_b("Material", 8) ? nbtItem.func_74779_i("Material").toLowerCase() : "leather") {
            case "diamond": {
                return ItemArmor.ArmorMaterial.DIAMOND;
            }
            case "chain": {
                return ItemArmor.ArmorMaterial.CHAIN;
            }
            case "iron": {
                return ItemArmor.ArmorMaterial.IRON;
            }
            case "gold": {
                return ItemArmor.ArmorMaterial.GOLD;
            }
        }
        return ItemArmor.ArmorMaterial.LEATHER;
    }

    public static EntityEquipmentSlot getSlotEquipment(String slotName) {
        switch (slotName = slotName.toLowerCase()) {
            case "head": {
                return EntityEquipmentSlot.HEAD;
            }
            case "chest": {
                return EntityEquipmentSlot.CHEST;
            }
            case "legs": {
                return EntityEquipmentSlot.LEGS;
            }
        }
        return EntityEquipmentSlot.FEET;
    }

    public CustomArmor(ItemArmor.ArmorMaterial materialIn, int renderIndexIn, EntityEquipmentSlot equipmentSlotIn, int maxStackDamage, int damageReduceAmount, float toughness, NBTTagCompound nbtItem) {
        super(materialIn, renderIndexIn, equipmentSlotIn);
        this.nbtData = nbtItem;
        String name = "custom_" + nbtItem.func_74779_i("RegistryName") + "_" + equipmentSlotIn.name().toLowerCase();
        this.setRegistryName("customnpcs", name);
        this.func_77655_b(name);
        this.func_77637_a(CustomRegisters.tabItems);
        if (nbtItem.func_150297_b("IsFull3D", 1) && nbtItem.func_74767_n("IsFull3D")) {
            this.func_77664_n();
        }
        if (maxStackDamage > 1) {
            this.func_77656_e(maxStackDamage);
        }
        if (damageReduceAmount > 0) {
            ItemArmorReflection.setDamageReduceAmount(this, damageReduceAmount);
        }
        if (toughness > 0.0f) {
            ItemArmorReflection.setToughness(this, toughness);
        }
        this.repairItemStack = nbtItem.func_150297_b("RepairItem", 10) ? new ItemStack(nbtItem.func_74775_l("RepairItem")) : materialIn.getRepairItemStack();
        if (nbtItem.func_150297_b("Enchantability", 3)) {
            this.enchantability = nbtItem.func_74762_e("Enchantability");
        }
        if (this.nbtData.func_150297_b("OBJData", 10)) {
            NBTTagCompound data = this.nbtData.func_74775_l("OBJData");
            NBTTagList tagList = data.func_150295_c("Head Mesh Names", 8);
            ArrayList<String> listHead = new ArrayList<String>();
            if (tagList.func_74745_c() > 0) {
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    listHead.add(tagList.func_150307_f(i));
                }
            }
            this.parts.put(EnumParts.HEAD, listHead);
            this.parts.put(EnumParts.MOHAWK, listHead);
            tagList = data.func_150295_c("Body Mesh Names", 8);
            ArrayList<String> listBody = new ArrayList<String>();
            if (tagList.func_74745_c() > 0) {
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    listBody.add(tagList.func_150307_f(i));
                }
            }
            this.parts.put(EnumParts.BODY, listBody);
            tagList = data.func_150295_c("Arm Right Mesh Names", 8);
            ArrayList<String> listArmRight = new ArrayList<String>();
            if (tagList.func_74745_c() > 0) {
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    listArmRight.add(tagList.func_150307_f(i));
                }
            }
            this.parts.put(EnumParts.ARM_RIGHT, listArmRight);
            tagList = data.func_150295_c("Wrist Right Mesh Names", 8);
            ArrayList<String> listWristRight = new ArrayList<String>();
            if (tagList.func_74745_c() > 0) {
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    listWristRight.add(tagList.func_150307_f(i));
                }
            }
            this.parts.put(EnumParts.WRIST_RIGHT, listWristRight);
            tagList = data.func_150295_c("Arm Left Mesh Names", 8);
            ArrayList<String> listArmLeft = new ArrayList<String>();
            if (tagList.func_74745_c() > 0) {
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    listArmLeft.add(tagList.func_150307_f(i));
                }
            }
            this.parts.put(EnumParts.ARM_LEFT, listArmLeft);
            tagList = data.func_150295_c("Wrist Left Mesh Names", 8);
            ArrayList<String> listWristLeft = new ArrayList<String>();
            if (tagList.func_74745_c() > 0) {
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    listWristLeft.add(tagList.func_150307_f(i));
                }
            }
            this.parts.put(EnumParts.WRIST_LEFT, listWristLeft);
            tagList = data.func_150295_c("Belt Mesh Names", 8);
            ArrayList<String> listBelt = new ArrayList<String>();
            if (tagList.func_74745_c() > 0) {
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    listBelt.add(tagList.func_150307_f(i));
                }
            }
            this.parts.put(EnumParts.BELT, listBelt);
            tagList = data.func_150295_c("Leg Right Mesh Names", 8);
            ArrayList<String> listLegRight = new ArrayList<String>();
            if (tagList.func_74745_c() > 0) {
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    listLegRight.add(tagList.func_150307_f(i));
                }
            }
            this.parts.put(EnumParts.LEG_RIGHT, listLegRight);
            tagList = data.func_150295_c("Foot Right Mesh Names", 8);
            ArrayList<String> listFootRight = new ArrayList<String>();
            if (tagList.func_74745_c() > 0) {
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    listFootRight.add(tagList.func_150307_f(i));
                }
            }
            this.parts.put(EnumParts.FOOT_RIGHT, listFootRight);
            tagList = data.func_150295_c("Leg Left Mesh Names", 8);
            ArrayList<String> listLegLeft = new ArrayList<String>();
            if (tagList.func_74745_c() > 0) {
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    listLegLeft.add(tagList.func_150307_f(i));
                }
            }
            this.parts.put(EnumParts.LEG_LEFT, listLegLeft);
            tagList = data.func_150295_c("Foot Left Mesh Names", 8);
            ArrayList<String> listFootLeft = new ArrayList<String>();
            if (tagList.func_74745_c() > 0) {
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    listFootLeft.add(tagList.func_150307_f(i));
                }
            }
            this.parts.put(EnumParts.FOOT_LEFT, listFootLeft);
            tagList = data.func_150295_c("Boot Right Mesh Names", 8);
            ArrayList<String> listBootRight = new ArrayList<String>();
            if (tagList.func_74745_c() > 0) {
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    listBootRight.add(tagList.func_150307_f(i));
                }
            }
            this.parts.put(EnumParts.FEET_RIGHT, listBootRight);
            tagList = data.func_150295_c("Boot Left Mesh Names", 8);
            ArrayList<String> listBootLeft = new ArrayList<String>();
            if (tagList.func_74745_c() > 0) {
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    listBootLeft.add(tagList.func_150307_f(i));
                }
            }
            this.parts.put(EnumParts.FEET_LEFT, listBootLeft);
            this.objModel = new ResourceLocation("customnpcs", "models/armor/" + nbtItem.func_74779_i("RegistryName") + ".obj");
            if (Thread.currentThread().getName().toLowerCase().contains("client")) {
                this.createCameraData();
            }
        } else if (this.nbtData.func_150297_b("OBJData", 9)) {
            NBTTagList data = this.nbtData.func_150295_c("OBJData", 10);
            for (EnumParts part : EnumParts.values()) {
                NBTTagCompound nbt = null;
                switch (part) {
                    case HEAD: 
                    case MOHAWK: {
                        nbt = data.func_150305_b(0);
                        break;
                    }
                    case BODY: {
                        nbt = data.func_150305_b(1);
                        break;
                    }
                    case ARM_RIGHT: {
                        nbt = data.func_150305_b(2);
                        break;
                    }
                    case ARM_LEFT: {
                        nbt = data.func_150305_b(3);
                        break;
                    }
                    case BELT: {
                        nbt = data.func_150305_b(4);
                        break;
                    }
                    case LEG_RIGHT: {
                        nbt = data.func_150305_b(5);
                        break;
                    }
                    case LEG_LEFT: {
                        nbt = data.func_150305_b(6);
                        break;
                    }
                    case FEET_RIGHT: {
                        nbt = data.func_150305_b(7);
                        break;
                    }
                    case FEET_LEFT: {
                        nbt = data.func_150305_b(8);
                        break;
                    }
                    case WRIST_RIGHT: {
                        nbt = data.func_150305_b(9);
                        break;
                    }
                    case WRIST_LEFT: {
                        nbt = data.func_150305_b(10);
                        break;
                    }
                    case FOOT_RIGHT: {
                        nbt = data.func_150305_b(11);
                        break;
                    }
                    case FOOT_LEFT: {
                        nbt = data.func_150305_b(12);
                        break;
                    }
                }
                if (nbt == null) continue;
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < nbt.func_150295_c("meshes", 8).func_74745_c(); ++i) {
                    list.add(nbt.func_150295_c("meshes", 8).func_150307_f(i));
                }
                this.parts.put(part, list);
            }
            this.objModel = new ResourceLocation("customnpcs", "models/armor/" + nbtItem.func_74779_i("RegistryName") + ".obj");
            if (Thread.currentThread().getName().toLowerCase().contains("client")) {
                this.createCameraData();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(@Nonnull EntityLivingBase entity, @Nonnull ItemStack itemStack, @Nonnull EntityEquipmentSlot slot, @Nonnull ModelBiped defModel) {
        if (this.objModel != null) {
            return ModelBuffer.getOBJModelBiped(this, entity, defModel);
        }
        return super.getArmorModel(entity, itemStack, slot, defModel);
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(@Nonnull ItemStack stack, @Nonnull Entity entity, @Nonnull EntityEquipmentSlot slot, @Nonnull String type) {
        if (this.objModel != null) {
            return "customnpcs:textures/items/null.png";
        }
        return "customnpcs:textures/models/armor/" + this.nbtData.func_74779_i("RegistryName") + "_layer_" + (slot == EntityEquipmentSlot.LEGS ? "2" : "1") + ".png";
    }

    @Override
    public String getCustomName() {
        return this.nbtData.func_74779_i("RegistryName");
    }

    @Override
    public INbt getCustomNbt() {
        return Objects.requireNonNull(NpcAPI.Instance()).getINbt(this.nbtData);
    }

    public boolean func_82789_a(@Nonnull ItemStack toRepair, @Nonnull ItemStack repair) {
        ItemStack mat = this.repairItemStack;
        if (this.repairItemStack.func_190926_b()) {
            mat = this.func_82812_d().getRepairItemStack();
        }
        if (!mat.func_190926_b() && OreDictionary.itemMatches((ItemStack)mat, (ItemStack)repair, (boolean)false)) {
            return true;
        }
        return super.func_82789_a(toRepair, repair);
    }

    public int func_77619_b() {
        if (this.enchantability > 0) {
            return this.enchantability;
        }
        return super.func_77619_b();
    }

    public List<String> getMeshNames(EnumParts slot) {
        if (this.parts.containsKey((Object)slot)) {
            return this.parts.get((Object)slot);
        }
        return new ArrayList<String>();
    }

    private void createCameraData() {
        this.cameraData.clear();
        NBTTagCompound display = this.nbtData.func_150297_b("Display", 10) ? this.nbtData.func_74775_l("Display") : new NBTTagCompound();
        NBTTagCompound head = display.func_150297_b("HEAD", 10) ? this.nbtData.func_74775_l("HEAD") : new NBTTagCompound();
        NBTTagCompound chest = display.func_150297_b("CHEST", 10) ? this.nbtData.func_74775_l("CHEST") : new NBTTagCompound();
        NBTTagCompound legs = display.func_150297_b("LEGS", 10) ? this.nbtData.func_74775_l("LEGS") : new NBTTagCompound();
        NBTTagCompound feet = display.func_150297_b("FEET", 10) ? this.nbtData.func_74775_l("FEET") : new NBTTagCompound();
        for (ItemCameraTransforms.TransformType transformType : ItemCameraTransforms.TransformType.values()) {
            Vector3f rotation = new Vector3f();
            Vector3f translation = new Vector3f();
            Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);
            block0 : switch (transformType) {
                case THIRD_PERSON_LEFT_HAND: {
                    Vector3f[] data;
                    switch (this.func_185083_B_()) {
                        case CHEST: {
                            if (!chest.func_150297_b("thirdperson_lefthand", 10)) {
                                translation.z = 0.5f;
                                scale.x = 0.5f;
                                scale.y = 0.5f;
                                scale.z = 0.5f;
                                break block0;
                            }
                            data = this.setOptional(rotation, translation, scale, chest.func_74775_l("thirdperson_lefthand"));
                            rotation = data[0];
                            translation = data[1];
                            scale = data[2];
                            break block0;
                        }
                        case LEGS: {
                            if (!legs.func_150297_b("thirdperson_lefthand", 10)) {
                                translation.x = -0.15f;
                                translation.y = 0.35f;
                                translation.z = 0.5f;
                                scale.x = 0.65f;
                                scale.y = 0.65f;
                                scale.z = 0.65f;
                                break block0;
                            }
                            data = this.setOptional(rotation, translation, scale, legs.func_74775_l("thirdperson_lefthand"));
                            rotation = data[0];
                            translation = data[1];
                            scale = data[2];
                            break block0;
                        }
                        case FEET: {
                            if (!feet.func_150297_b("thirdperson_lefthand", 10)) {
                                rotation.x = 90.0f;
                                rotation.y = 180.0f;
                                translation.x = 1.15f;
                                translation.y = 0.5f;
                                translation.z = 0.5f;
                                scale.x = 0.65f;
                                scale.y = 0.65f;
                                scale.z = 0.65f;
                                break block0;
                            }
                            data = this.setOptional(rotation, translation, scale, feet.func_74775_l("thirdperson_lefthand"));
                            rotation = data[0];
                            translation = data[1];
                            scale = data[2];
                            break block0;
                        }
                    }
                    if (!head.func_150297_b("thirdperson_lefthand", 10)) {
                        rotation.y = 180.0f;
                        translation.x = 1.0f;
                        translation.y = -0.375f;
                        translation.z = 0.5f;
                        scale.x = 0.5f;
                        scale.y = 0.5f;
                        scale.z = 0.5f;
                        break;
                    }
                    data = this.setOptional(rotation, translation, scale, head.func_74775_l("thirdperson_lefthand"));
                    rotation = data[0];
                    translation = data[1];
                    scale = data[2];
                    break;
                }
                case THIRD_PERSON_RIGHT_HAND: {
                    Vector3f[] data;
                    switch (this.func_185083_B_()) {
                        case CHEST: {
                            if (!chest.func_150297_b("thirdperson_righthand", 10)) {
                                translation.x = 0.5f;
                                translation.z = 0.5f;
                                scale.x = 0.5f;
                                scale.y = 0.5f;
                                scale.z = 0.5f;
                                break block0;
                            }
                            data = this.setOptional(rotation, translation, scale, chest.func_74775_l("thirdperson_righthand"));
                            rotation = data[0];
                            translation = data[1];
                            scale = data[2];
                            break block0;
                        }
                        case LEGS: {
                            if (!legs.func_150297_b("thirdperson_righthand", 10)) {
                                translation.x = 0.5f;
                                translation.y = 0.35f;
                                translation.z = 0.5f;
                                scale.x = 0.65f;
                                scale.y = 0.65f;
                                scale.z = 0.65f;
                                break block0;
                            }
                            data = this.setOptional(rotation, translation, scale, legs.func_74775_l("thirdperson_righthand"));
                            rotation = data[0];
                            translation = data[1];
                            scale = data[2];
                            break block0;
                        }
                        case FEET: {
                            if (!feet.func_150297_b("firstperson_righthand", 10)) {
                                rotation.x = 90.0f;
                                rotation.y = 180.0f;
                                translation.x = 0.5f;
                                translation.y = 0.5f;
                                translation.z = 0.5f;
                                scale.x = 0.65f;
                                scale.y = 0.65f;
                                scale.z = 0.65f;
                                break block0;
                            }
                            data = this.setOptional(rotation, translation, scale, feet.func_74775_l("firstperson_righthand"));
                            rotation = data[0];
                            translation = data[1];
                            scale = data[2];
                            break block0;
                        }
                    }
                    if (!head.func_150297_b("thirdperson_righthand", 10)) {
                        rotation.y = 180.0f;
                        translation.x = 0.5f;
                        translation.y = -0.375f;
                        translation.z = 0.5f;
                        scale.x = 0.5f;
                        scale.y = 0.5f;
                        scale.z = 0.5f;
                        break;
                    }
                    data = this.setOptional(rotation, translation, scale, head.func_74775_l("thirdperson_righthand"));
                    rotation = data[0];
                    translation = data[1];
                    scale = data[2];
                    break;
                }
                case FIRST_PERSON_LEFT_HAND: {
                    Vector3f[] data;
                    switch (this.func_185083_B_()) {
                        case CHEST: {
                            if (!chest.func_150297_b("firstperson_lefthand", 10)) {
                                rotation.y = 280.0f;
                                translation.x = 0.57f;
                                translation.y = 0.1f;
                                translation.z = -0.085f;
                                scale.x = 0.5f;
                                scale.y = 0.5f;
                                scale.z = 0.5f;
                                break block0;
                            }
                            data = this.setOptional(rotation, translation, scale, chest.func_74775_l("firstperson_lefthand"));
                            rotation = data[0];
                            translation = data[1];
                            scale = data[2];
                            break block0;
                        }
                        case LEGS: {
                            if (!legs.func_150297_b("firstperson_lefthand", 10)) {
                                rotation.y = 280.0f;
                                translation.x = 0.65f;
                                translation.y = 0.4f;
                                translation.z = -0.085f;
                                scale.x = 0.5f;
                                scale.y = 0.5f;
                                scale.z = 0.5f;
                                break block0;
                            }
                            data = this.setOptional(rotation, translation, scale, legs.func_74775_l("firstperson_lefthand"));
                            rotation = data[0];
                            translation = data[1];
                            scale = data[2];
                            break block0;
                        }
                        case FEET: {
                            if (!feet.func_150297_b("firstperson_lefthand", 10)) {
                                rotation.y = 280.0f;
                                translation.x = 0.72f;
                                translation.y = 0.435f;
                                translation.z = -0.585f;
                                scale.x = 0.85f;
                                scale.y = 0.85f;
                                scale.z = 0.85f;
                                break block0;
                            }
                            data = this.setOptional(rotation, translation, scale, feet.func_74775_l("firstperson_lefthand"));
                            rotation = data[0];
                            translation = data[1];
                            scale = data[2];
                            break block0;
                        }
                    }
                    if (!head.func_150297_b("firstperson_lefthand", 10)) {
                        rotation.y = 280.0f;
                        translation.x = 0.57f;
                        translation.y = -0.225f;
                        translation.z = -0.085f;
                        scale.x = 0.5f;
                        scale.y = 0.5f;
                        scale.z = 0.5f;
                        break;
                    }
                    data = this.setOptional(rotation, translation, scale, head.func_74775_l("firstperson_lefthand"));
                    rotation = data[0];
                    translation = data[1];
                    scale = data[2];
                    break;
                }
                case FIRST_PERSON_RIGHT_HAND: {
                    Vector3f[] data;
                    switch (this.func_185083_B_()) {
                        case CHEST: {
                            if (!chest.func_150297_b("firstperson_righthand", 10)) {
                                rotation.y = 280.0f;
                                translation.x = 0.85f;
                                translation.y = -0.1f;
                                translation.z = 0.2f;
                                scale.x = 0.6f;
                                scale.y = 0.6f;
                                scale.z = 0.6f;
                                break block0;
                            }
                            data = this.setOptional(rotation, translation, scale, chest.func_74775_l("firstperson_righthand"));
                            rotation = data[0];
                            translation = data[1];
                            scale = data[2];
                            break block0;
                        }
                        case LEGS: {
                            if (!legs.func_150297_b("firstperson_righthand", 10)) {
                                rotation.y = 280.0f;
                                translation.x = 0.95f;
                                translation.y = 0.25f;
                                translation.z = 0.2f;
                                scale.x = 0.6f;
                                scale.y = 0.6f;
                                scale.z = 0.6f;
                                break block0;
                            }
                            data = this.setOptional(rotation, translation, scale, legs.func_74775_l("firstperson_righthand"));
                            rotation = data[0];
                            translation = data[1];
                            scale = data[2];
                            break block0;
                        }
                        case FEET: {
                            if (!feet.func_150297_b("firstperson_righthand", 10)) {
                                rotation.y = 280.0f;
                                translation.x = 0.95f;
                                translation.y = 0.4f;
                                translation.z = 0.2f;
                                scale.x = 0.85f;
                                scale.y = 0.85f;
                                scale.z = 0.85f;
                                break block0;
                            }
                            data = this.setOptional(rotation, translation, scale, feet.func_74775_l("firstperson_righthand"));
                            rotation = data[0];
                            translation = data[1];
                            scale = data[2];
                            break block0;
                        }
                    }
                    if (!head.func_150297_b("firstperson_righthand", 10)) {
                        rotation.y = 280.0f;
                        translation.x = 0.85f;
                        translation.y = -0.5f;
                        translation.z = 0.2f;
                        scale.x = 0.6f;
                        scale.y = 0.6f;
                        scale.z = 0.6f;
                        break;
                    }
                    data = this.setOptional(rotation, translation, scale, head.func_74775_l("firstperson_righthand"));
                    rotation = data[0];
                    translation = data[1];
                    scale = data[2];
                    break;
                }
                case HEAD: {
                    Vector3f[] data;
                    switch (this.func_185083_B_()) {
                        case CHEST: {
                            if (!chest.func_150297_b("head", 10)) {
                                rotation.x = 270.0f;
                                translation.x = 0.5f;
                                translation.y = 1.0f;
                                translation.z = 1.65f;
                                break block0;
                            }
                            data = this.setOptional(rotation, translation, scale, chest.func_74775_l("head"));
                            rotation = data[0];
                            translation = data[1];
                            scale = data[2];
                            break block0;
                        }
                        case LEGS: {
                            if (!legs.func_150297_b("head", 10)) {
                                rotation.x = 270.0f;
                                translation.x = 0.5f;
                                translation.y = 1.0f;
                                translation.z = 1.0f;
                                break block0;
                            }
                            data = this.setOptional(rotation, translation, scale, legs.func_74775_l("head"));
                            rotation = data[0];
                            translation = data[1];
                            scale = data[2];
                            break block0;
                        }
                        case FEET: {
                            if (!feet.func_150297_b("head", 10)) {
                                rotation.y = 180.0f;
                                translation.x = 0.5f;
                                translation.y = 0.925f;
                                translation.z = 0.4f;
                                break block0;
                            }
                            data = this.setOptional(rotation, translation, scale, feet.func_74775_l("head"));
                            rotation = data[0];
                            translation = data[1];
                            scale = data[2];
                            break block0;
                        }
                    }
                    break;
                }
                case GUI: {
                    Vector3f[] data;
                    switch (this.func_185083_B_()) {
                        case CHEST: {
                            if (!chest.func_150297_b("gui", 10)) {
                                rotation.x = 30.0f;
                                rotation.y = 45.0f;
                                translation.x = 0.49f;
                                translation.y = -0.41f;
                                scale.x = 0.9f;
                                scale.y = 0.9f;
                                scale.z = 0.9f;
                                break block0;
                            }
                            data = this.setOptional(rotation, translation, scale, chest.func_74775_l("gui"));
                            rotation = data[0];
                            translation = data[1];
                            scale = data[2];
                            break block0;
                        }
                        case LEGS: {
                            if (!legs.func_150297_b("gui", 10)) {
                                rotation.x = 30.0f;
                                rotation.y = 45.0f;
                                translation.x = 0.5f;
                                translation.y = 0.05f;
                                break block0;
                            }
                            data = this.setOptional(rotation, translation, scale, legs.func_74775_l("gui"));
                            rotation = data[0];
                            translation = data[1];
                            scale = data[2];
                            break block0;
                        }
                        case FEET: {
                            if (!feet.func_150297_b("gui", 10)) {
                                rotation.x = 30.0f;
                                rotation.y = 45.0f;
                                translation.x = 0.5f;
                                translation.y = 0.3f;
                                break block0;
                            }
                            data = this.setOptional(rotation, translation, scale, feet.func_74775_l("gui"));
                            rotation = data[0];
                            translation = data[1];
                            scale = data[2];
                            break block0;
                        }
                    }
                    if (!head.func_150297_b("gui", 10)) {
                        rotation.x = 30.0f;
                        rotation.y = 45.0f;
                        translation.x = 0.5f;
                        translation.y = -1.0f;
                        break;
                    }
                    data = this.setOptional(rotation, translation, scale, head.func_74775_l("gui"));
                    rotation = data[0];
                    translation = data[1];
                    scale = data[2];
                    break;
                }
                case GROUND: {
                    Vector3f[] data;
                    switch (this.func_185083_B_()) {
                        case CHEST: {
                            if (!chest.func_150297_b("ground", 10)) {
                                translation.x = 0.5f;
                                translation.z = 0.5f;
                                scale.x = 0.5f;
                                scale.y = 0.5f;
                                scale.z = 0.5f;
                                break block0;
                            }
                            data = this.setOptional(rotation, translation, scale, chest.func_74775_l("ground"));
                            rotation = data[0];
                            translation = data[1];
                            scale = data[2];
                            break block0;
                        }
                        case LEGS: {
                            if (!legs.func_150297_b("ground", 10)) {
                                translation.x = 0.5f;
                                translation.y = 0.25f;
                                translation.z = 0.5f;
                                scale.x = 0.6f;
                                scale.y = 0.6f;
                                scale.z = 0.6f;
                                break block0;
                            }
                            data = this.setOptional(rotation, translation, scale, legs.func_74775_l("ground"));
                            rotation = data[0];
                            translation = data[1];
                            scale = data[2];
                            break block0;
                        }
                        case FEET: {
                            if (!feet.func_150297_b("ground", 10)) {
                                translation.x = 0.5f;
                                translation.y = 0.35f;
                                translation.z = 0.5f;
                                scale.x = 0.65f;
                                scale.y = 0.65f;
                                scale.z = 0.65f;
                                break block0;
                            }
                            data = this.setOptional(rotation, translation, scale, feet.func_74775_l("ground"));
                            rotation = data[0];
                            translation = data[1];
                            scale = data[2];
                            break block0;
                        }
                    }
                    if (!head.func_150297_b("ground", 10)) {
                        translation.x = 0.5f;
                        translation.y = -0.375f;
                        translation.z = 0.5f;
                        scale.x = 0.5f;
                        scale.y = 0.5f;
                        scale.z = 0.5f;
                        break;
                    }
                    data = this.setOptional(rotation, translation, scale, head.func_74775_l("ground"));
                    rotation = data[0];
                    translation = data[1];
                    scale = data[2];
                    break;
                }
                case FIXED: {
                    Vector3f[] data;
                    switch (this.func_185083_B_()) {
                        case CHEST: {
                            if (!chest.func_150297_b("fixed", 10)) {
                                rotation.y = 180.0f;
                                translation.x = 0.5f;
                                translation.y = -0.65f;
                                translation.z = 0.45f;
                                break block0;
                            }
                            data = this.setOptional(rotation, translation, scale, chest.func_74775_l("fixed"));
                            rotation = data[0];
                            translation = data[1];
                            scale = data[2];
                            break block0;
                        }
                        case LEGS: {
                            if (!legs.func_150297_b("fixed", 10)) {
                                rotation.y = 180.0f;
                                translation.x = 0.5f;
                                translation.y = 0.05f;
                                translation.z = 0.475f;
                                break block0;
                            }
                            data = this.setOptional(rotation, translation, scale, legs.func_74775_l("fixed"));
                            rotation = data[0];
                            translation = data[1];
                            scale = data[2];
                            break block0;
                        }
                        case FEET: {
                            if (!feet.func_150297_b("fixed", 10)) {
                                rotation.y = 180.0f;
                                translation.x = 0.5f;
                                translation.y = 0.2f;
                                translation.z = 0.475f;
                                break block0;
                            }
                            data = this.setOptional(rotation, translation, scale, feet.func_74775_l("fixed"));
                            rotation = data[0];
                            translation = data[1];
                            scale = data[2];
                            break block0;
                        }
                    }
                    if (!head.func_150297_b("fixed", 10)) {
                        rotation.y = 180.0f;
                        translation.x = 0.5f;
                        translation.y = -0.85f;
                        translation.z = 0.4f;
                        scale.x = 0.75f;
                        scale.y = 0.75f;
                        scale.z = 0.75f;
                        break;
                    }
                    data = this.setOptional(rotation, translation, scale, head.func_74775_l("fixed"));
                    rotation = data[0];
                    translation = data[1];
                    scale = data[2];
                    break;
                }
            }
            this.cameraData.put(transformType, Optional.of(TRSRTransformation.from((ItemTransformVec3f)new ItemTransformVec3f(rotation, translation, scale))));
        }
    }

    private Vector3f[] setOptional(Vector3f rotation, Vector3f translation, Vector3f scale, NBTTagCompound compound) {
        NBTTagList list;
        if (compound.func_150297_b("rotation", 9)) {
            list = compound.func_150295_c("rotation", 5);
            if (list.func_74745_c() > 0) {
                rotation.x = list.func_150308_e(0);
            }
            if (list.func_74745_c() > 1) {
                rotation.y = list.func_150308_e(1);
            }
            if (list.func_74745_c() > 2) {
                rotation.z = list.func_150308_e(2);
            }
        }
        if (compound.func_150297_b("translation", 9)) {
            list = compound.func_150295_c("translation", 5);
            if (list.func_74745_c() > 0) {
                translation.x = list.func_150308_e(0);
            }
            if (list.func_74745_c() > 1) {
                translation.y = list.func_150308_e(1);
            }
            if (list.func_74745_c() > 2) {
                translation.z = list.func_150308_e(2);
            }
        }
        if (compound.func_150297_b("scale", 9)) {
            list = compound.func_150295_c("scale", 5);
            if (list.func_74745_c() > 0) {
                scale.x = list.func_150308_e(0);
            }
            if (list.func_74745_c() > 1) {
                scale.y = list.func_150308_e(1);
            }
            if (list.func_74745_c() > 2) {
                scale.z = list.func_150308_e(2);
            }
        }
        return new Vector3f[]{rotation, translation, scale};
    }

    public Optional<TRSRTransformation> getOptional(ItemCameraTransforms.TransformType transformType) {
        return this.cameraData.get(transformType);
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (tab != CustomRegisters.tabItems && tab != CreativeTabs.field_78027_g) {
            return;
        }
        if (this.nbtData != null && this.nbtData.func_150297_b("ShowInCreative", 1) && !this.nbtData.func_74767_n("ShowInCreative")) {
            return;
        }
        items.add((Object)new ItemStack((Item)this));
        if (tab == CustomRegisters.tabItems) {
            Util.instance.sort(items);
        }
    }

    @Override
    public int getType() {
        if (this.nbtData != null && this.nbtData.func_150297_b("ItemType", 1)) {
            return this.nbtData.func_74771_c("ItemType");
        }
        return 0;
    }
}

